<?php
/*
Plugin Name: PW Pro Newsticker & Marquee Layout for visual composer
Plugin URI: http://proword.net/Plugins/VC_Pro_Post_Layout/ticker-main/
Description: Make your news ticker from WP posts, RSS feeds or manual text with many awesome and easy options
Author: Proword
Version: 1.3.2
Author URI: http://proword.net/
Text Domain: pw_pro_news_ticker
 */

/*
V1.3.2:
fixed: Some CSS issue.
fixed: Some PHP issue.
Compatible: With WPBakery 5.x
Compatible: With WordPress 5.x
 * */

/*
V1.3.1:
fixed: Some CSS issue.
fixed: Bxslider jquery issue.
 * */

/*
V1.3:
fixed: Some CSS issue.
fixed: Link issue on manual ticker.
fixed: Compatible with PHP 7.x and higher.
Update: Bxslider jquery.
 * */
define('plugin_dir_url_pw_pro_news_ticker', plugin_dir_url( __FILE__ ));
define ('__PW_PRO_NEWS_TICKER_ROOT_VC_URL__',plugins_url('', __FILE__));
define( '__PW_PRO_NEWS_TICKER_ROOT_VC__', dirname(__FILE__));

define ('PW_PRO_NEWS_TICKER_TEXTDOMAIN','pw_pro_news_ticker');
//PERFIX
define ('__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__', 'pro-news-ticker' );

 

class pw_pro_news_ticker_plugin  {
	public function __construct() 
	{
		
		include("includes/actions.php");
		
		//Add Shortcode Post And Page
		add_filter('init', array( $this,'pw_pro_news_ticker_shortcodes_add_scripts'));
		
		//Add And Remove Param
		add_action( 'init', array( $this, 'integrateWithVC' ) );
		

		add_action('admin_enqueue_scripts',array($this,'pw_pro_news_ticker_admin_scripts'));
		
		

		$this->includes();
	}
	

	
	//Add And Remove Param
	public function integrateWithVC() {
		// Check if Visual Composer is installed
		if ( ! defined( 'WPB_VC_VERSION' ) ) {
			return;
		}
		if(function_exists('vc_add_shortcode_param')){
				vc_add_shortcode_param('pw_googlefonts', array($this,'pw_googlefonts_settings_field'));
				vc_add_shortcode_param('pw_number' , array($this, 'pw_number_settings_field' ) );
				vc_add_shortcode_param('pw_button' , array($this, 'pw_button_settings_field' ) );
				
				vc_add_shortcode_param('pw_image_radio',array($this,'pw_image_radio_settings_field'));
				vc_add_shortcode_param('pw_fontawesome', array($this,'fontawesome_settings_field'));
				
				vc_add_shortcode_param('pw_simple_font', array($this,'pw_simple_font_settings_field'));
				vc_add_shortcode_param('pw_adv_font', array($this,'pw_adv_font_settings_field'));
				vc_add_shortcode_param('pw_border_option', array($this,'pw_border_settings_field'));
				

				
			}else if(function_exists('add_shortcode_param'))
			{
				add_shortcode_param('pw_googlefonts', array($this,'pw_googlefonts_settings_field'));
				add_shortcode_param('pw_number' , array($this, 'pw_number_settings_field' ) );
				add_shortcode_param('pw_button' , array($this, 'pw_button_settings_field' ) );
				
				add_shortcode_param('pw_image_radio',array($this,'pw_image_radio_settings_field'));
				add_shortcode_param('pw_fontawesome', array($this,'fontawesome_settings_field'));
				
				add_shortcode_param('pw_simple_font', array($this,'pw_simple_font_settings_field'));
				add_shortcode_param('pw_adv_font', array($this,'pw_adv_font_settings_field'));
				add_shortcode_param('pw_border_option', array($this,'pw_border_settings_field'));
				

			}
			
			
		
	}
	
	
		
	function pw_pro_news_ticker_admin_scripts()
		{
			wp_enqueue_style('pw_pro_news_ticker_font-awesome', __PW_PRO_NEWS_TICKER_ROOT_VC_URL__ .'/css/fontawesome/font-awesome.css');
			wp_enqueue_style('pw_pro_news_ticker_font-awesome_style', __PW_PRO_NEWS_TICKER_ROOT_VC_URL__ .'/css/fontawesome/style.css');	
			
			wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_custom_css', plugin_dir_url_pw_pro_news_ticker.'/css/fontawesome/font-awesome.css');
			
		//	wp_enqueue_script('jquery');
			//wp_enqueue_script('wp-color-picker');		
			
			wp_enqueue_style('pw_pro_news_ticker_font-custom-js', __PW_PRO_NEWS_TICKER_ROOT_VC_URL__ .'/css/back-end/custom_css_back.css');
			
		}	
		
	//Number Param
	function pw_number_settings_field($settings, $value){
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$min = isset($settings['min']) ? $settings['min'] : '';
		$max = isset($settings['max']) ? $settings['max'] : '';
		$suffix = isset($settings['suffix']) ? $settings['suffix'] : '';		   
		$output = '<input name="'.$settings['param_name']
				.'" class="wpb_vc_param_value wpb-textinput '
				.$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" id="'
				.$settings['param_name'].'" type="number" min="'.$min.'" max="'.$max.'" value="'.$value.'" ' . $dependency . 'style="max-width:100px; margin-right: 10px;" />'.$suffix;
				
		return $output;
	}

	/*image radio Param*/
	function pw_image_radio_settings_field($settings, $value) {
			$param_line='';
			$dependency = '';

			$optoin='';
			$current_value =  $value;
			$values = $settings['value'];
			foreach ( $values as $label => $v ) {
				$selected='';	
				if($v==$value)		
					$selected='SELECTED';
				$optoin.='<option value="' . $v . '" '.$selected.'> ' . $v . '</option>';
			}

			$param_line = '<select style="display:none"  name="'.$settings['param_name'].'" class="wpb_vc_param_value wpb-textinput '
					 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" id="'.$settings['param_name'].'-radio-img" type="hidden">'.$optoin.'</select>';

			
					 
			$current_value =  $value;
			$values = $settings['value'];
			foreach ( $values as $label => $v ) {
				$class = ($v==$current_value) ? ' pw_radio_img_checked' : '';
				$param_line .= '
					<span data-value="' . $v . '" class="pw_radio_img_items '
					 .$settings['param_name'].'_type_radio '.$class.'"> ' . __($label, "js_composer").'</span>';
			}
           $param_line.= '<script type="text/javascript">
							jQuery(document).ready(function(){								
								jQuery(".'
					 .$settings['param_name'].'_type_radio").click(function(){
						 			jQuery(this).siblings().removeClass("pw_radio_img_checked");
									jQuery(this).addClass("pw_radio_img_checked");
									/*jQuery("#'.$settings['param_name'].'-radio-img").val(jQuery(this).attr("data-value"));*/									
									jQuery("#'.$settings['param_name'].'-radio-img option[value="+jQuery(this).attr("data-value")+"]").prop("selected", true);
									jQuery("#'.$settings['param_name'].'-radio-img").trigger("change");
								});
							});
						</script>';
			
			return $param_line;
		}
		
	/*FontAweome*/
	function fontawesome_settings_field($settings, $value) {
			$dependency = '';
			$ret = include("includes/font-awesome.php");
			return  '<div class="pw_iconpicker my_param_block">'
					 .'<input name="'.$settings['param_name']
					 .'" class="wpb_vc_param_value wpb-textinput '
					 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" id="font_icon" type="hidden" value="'
					 .$value.'" ' . $dependency . '/>'.
					 $ret
					 .'</div>'
					.'<script type="text/javascript">
							jQuery(document).ready(function(){
								if(jQuery("#font_icon").val()!="")
								{
									jQuery("."+jQuery("#font_icon").val()).siblings( ".active" ).removeClass( "active" );
									jQuery("."+jQuery("#font_icon").val()).addClass("active");
								}
								
								jQuery(".pw_iconpicker i").click(function(){
									var val=(jQuery(this).attr("class").split(" ")[0]!="fa-none" ? jQuery(this).attr("class").split(" ")[0]:"");
									jQuery("#font_icon").val(val);
									jQuery(this).siblings( ".active" ).removeClass( "active" );
									jQuery(this).addClass("active");
								});
							});
						</script>					
					'; 
 		}
		
	/*google font param*/	
	function pw_get_googlefonts($selected=''){
			require __PW_PRO_NEWS_TICKER_ROOT_VC__.'/includes/google-fonts.php';
			$font_options='';
			foreach($fonts_array as $key=>$value){
				$font_options.='<option '.selected($selected,$key,0).' value="'.$key.'">'.$value.'</option>';
			}
			return $font_options;
		}	
	function pw_googlefonts_settings_field($settings, $value){
			$dependency = '';
			
			$param_line='';
			
			$param_line.='
	
			<select name="'.$settings['param_name'].'" class="wpb_vc_param_value wpb-select '
				.$settings['param_name'].' '.$settings['type'].'_field" id="'.$settings['param_name'].'-family">
				<option value="inherit">Inherit</option>
				'.$this->pw_get_googlefonts($value).'
			</select>
			
			<script type="text/javascript">
				function isNumber(n) {
				  return !isNaN(parseFloat(n)) && isFinite(n);
				}
			
				jQuery(document).ready(function(){
					
					if(jQuery("#'.$settings['param_name'].'-family").val()!="inherit")
					{
						jQuery("head").append("<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family="+jQuery("#'.$settings['param_name'].'-family").val()+"\" />");	
						
						var $font_family=jQuery("#'.$settings['param_name'].'-family").val();
						var $font_arr=$font_family.split(":");
						if($font_arr.length>0 && isNumber($font_arr[1]))
						{
							$font_weight=$font_arr[1];
							$font_name=$font_arr[0].replace("+"," ");
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css({"font-family":$font_name,"font-weight":$font_weight});
						}else
						{
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery("#'.$settings['param_name'].'-family").find(":selected").text());
						}
						
						jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery("#'.$settings['param_name'].'-family").find(":selected").text());
					}
					
					jQuery("#'.$settings['param_name'].'-family").change(function(){
						jQuery("head").append("<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family="+jQuery(this).val()+"\" />");	
						
						var $font_family=jQuery(this).val();
						var $font_arr=$font_family.split(":");
						if($font_arr.length>0 && isNumber($font_arr[1]))
						{
							$font_weight=$font_arr[1];
							$font_name=$font_arr[0].replace("+"," ");
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css({"font-family":$font_name,"font-weight":$font_weight});
						}else
						{
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery(this).find(":selected").text());
						}
					});
					
				});
			
			</script>
			<p class="pw-check-font-'.$settings['param_name'].'-family">Grumpy wizards make toxic brew for the evil Queen and Jack.</p>
			
			';
			return $param_line;
		}
	
	//Simple Font Param
	function pw_simple_font_settings_field($settings, $value){
		$dependency='';
		
		$meta=array('inherit',0,"#FFFFFF");
		if($value!='')
		{
			$meta=explode(",",$value);
		}else{
			$value='';
		}
		$font_size= (isset($meta[1]) && $meta[1]!='0')?$meta[1]:'10';
		$param_line = '<input name="'.$settings['param_name']
			 .'" class="wpb_vc_param_value wpb-textinput '
			 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" id="'.$settings['param_name'].'-simple_font" type="hidden" value="'.$value.'" ' . $dependency . '/>
			 <div class="pl-field-cnt">
			 <label>Font Name</label>
			 <select name="'.$settings['param_name'].'" class="'.$settings['param_name'].'-simple_font wpb_vc_param_value wpb-select '
				.$settings['param_name'].' '.$settings['type'].'_field" id="'.$settings['param_name'].'-family" >
				<option value="inherit">Inherit</option>
				'.$this->pw_get_googlefonts($meta[0]).'
			</select>
			</div>
			<div class="pl-field-cnt">
			 <label>Size</label>
			 <input name="'.$settings['param_name']
			 .'" class="'.$settings['param_name'].'-simple_font wpb_vc_param_value wpb-textinput '
			 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="number" value="'.$font_size.'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;" />
			 </div>
			 <div class="pl-field-cnt">
			 <label>Color</label>
			 <input name="'.$settings['param_name']
			 .'" class="'.$settings['param_name'].'-colorpicker-simple_font '.$settings['param_name'].'-simple_font wpb_vc_param_value wpb-textinput '
			 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="text" value="'.$meta[2].'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;" data-default-color="#7C7C7C"/>
			 </div>
			 
			<script type="text/javascript">
				function isNumber(n) {
				  return !isNaN(parseFloat(n)) && isFinite(n);
				}
			
				jQuery(document).ready(function(){
					
					if(jQuery("#'.$settings['param_name'].'-family").val()!="inherit")
					{
						jQuery("head").append("<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family="+jQuery("#'.$settings['param_name'].'-family").val()+"\" />");	
						
						var $font_family=jQuery("#'.$settings['param_name'].'-family").val();
						var $font_arr=$font_family.split(":");
						if($font_arr.length>0 && isNumber($font_arr[1]))
						{
							$font_weight=$font_arr[1];
							$font_name=$font_arr[0].replace("+"," ");
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css({"font-family":$font_name,"font-weight":$font_weight});
						}else
						{
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery("#'.$settings['param_name'].'-family").find(":selected").text());
						}
						
						jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery("#'.$settings['param_name'].'-family").find(":selected").text());
					}
					
					jQuery("#'.$settings['param_name'].'-family").change(function(){
						jQuery("head").append("<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family="+jQuery(this).val()+"\" />");	
						
						var $font_family=jQuery(this).val();
						var $font_arr=$font_family.split(":");
						if($font_arr.length>0 && isNumber($font_arr[1]))
						{
							$font_weight=$font_arr[1];
							$font_name=$font_arr[0].replace("+"," ");
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css({"font-family":$font_name,"font-weight":$font_weight});
						}else
						{
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery(this).find(":selected").text());
						}
					});
					
				});
			
			</script>
			<p class="pw-check-font-'.$settings['param_name'].'-family">Grumpy wizards make toxic brew for the evil Queen and Jack.</p>
			
				
			<script type="text/javascript">
			
				var value_font=[];
				jQuery(document).ready(function(){
					
					jQuery(".'.$settings['param_name'].'-colorpicker-simple_font").wpColorPicker({
						change:function(event, ui) {
							
							value_font=[];
							jQuery("#'.$settings['param_name'].'-simple_font").val("");
							
							jQuery(".'.$settings['param_name'].'-simple_font").each(function(){
								
								if(jQuery(this).hasClass("'.$settings['param_name'].'-colorpicker-simple_font"))
									return;
								
								var font_field=jQuery(this).val();
								if(font_field!=""){
									value_font.push(font_field);			
								}else{
									font_field=0;
									value_font.push(font_field);				
								}
							});	
							value_font.push(ui.color.toString());
							var cur_val=value_font.join(",");
							jQuery("#'.$settings['param_name'].'-simple_font").val(cur_val);
						}
					});
					
					jQuery(".'.$settings['param_name'].'-simple_font").live("change",function(){
						value_font=[];
						jQuery("#'.$settings['param_name'].'-simple_font").val("");
						
						jQuery(".'.$settings['param_name'].'-simple_font").each(function(){
							var font_field=jQuery(this).val();
							if(font_field!=""){
								value_font.push(font_field);			
							}else{
								font_field=0;
								value_font.push(font_field);				
							}
						});	
						var cur_val=value_font.join(",");
						jQuery("#'.$settings['param_name'].'-simple_font").val(cur_val);
					});
					
				});
				
			</script>';
			 
			 
			 
		return $param_line;	 
	}
	
	//Advanced Font Param
	function pw_adv_font_settings_field($settings, $value){
		$dependency='';
		
		$meta=array('inherit',0,"#FFFFFF","#CCCCCC");
		if($value!='')
		{
			$meta=explode(",",$value);
		}else{
			$value='';
		}
		$font_size= (isset($meta[1]) && $meta[1]!='0')?$meta[1]:'10';
		$param_line = '<input name="'.$settings['param_name']
			 .'" class="wpb_vc_param_value wpb-textinput '
			 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" id="'.$settings['param_name'].'-adv_font" type="hidden" value="'.$value.'" ' . $dependency . '/>
			 <div class="pl-field-cnt">
			 <label>Font Name</label>
			 <select name="'.$settings['param_name'].'" class="'.$settings['param_name'].'-adv_font wpb_vc_param_value wpb-select '
				.$settings['param_name'].' '.$settings['type'].'_field" id="'.$settings['param_name'].'-family">
				<option value="inherit">Inherit</option>
				'.$this->pw_get_googlefonts($meta[0]).'
			</select>
			</div>
			<div class="pl-field-cnt">
			 <label>Size</label>
			 <input name="'.$settings['param_name']
			 .'" class="'.$settings['param_name'].'-adv_font wpb_vc_param_value wpb-textinput '
			 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="number" value="'.$font_size.'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;" />
			 </div>
			 <div class="pl-field-cnt">
			 <label>Color</label>
			 <input name="'.$settings['param_name']
			 .'" class="main_color '.$settings['param_name'].'-colorpicker-adv_font '.$settings['param_name'].'-adv_font wpb_vc_param_value wpb-textinput '
			 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="text" value="'.$meta[2].'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;" data-default-color="#7C7C7C"/>
			 </div>
			 <div class="pl-field-cnt">
			 <label>Hover Color</label>
			 <input name="'.$settings['param_name']
			 .'" class="hover_color '.$settings['param_name'].'-colorpicker-adv_font '.$settings['param_name'].'-adv_font wpb_vc_param_value wpb-textinput '
			 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="text" value="'.$meta[3].'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;" data-default-color="#7C7C7C"/>
			</div>
			
			
			<script type="text/javascript">
				function isNumber(n) {
				  return !isNaN(parseFloat(n)) && isFinite(n);
				}
			
				jQuery(document).ready(function(){
					
					if(jQuery("#'.$settings['param_name'].'-family").val()!="inherit")
					{
						jQuery("head").append("<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family="+jQuery("#'.$settings['param_name'].'-family").val()+"\" />");	
						
						var $font_family=jQuery("#'.$settings['param_name'].'-family").val();
						var $font_arr=$font_family.split(":");
						if($font_arr.length>0 && isNumber($font_arr[1]))
						{
							$font_weight=$font_arr[1];
							$font_name=$font_arr[0].replace("+"," ");
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css({"font-family":$font_name,"font-weight":$font_weight});
						}else
						{
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery("#'.$settings['param_name'].'-family").find(":selected").text());
						}
						
						jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery("#'.$settings['param_name'].'-family").find(":selected").text());
					}
					
					jQuery("#'.$settings['param_name'].'-family").change(function(){
						jQuery("head").append("<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family="+jQuery(this).val()+"\" />");	
						
						var $font_family=jQuery(this).val();
						var $font_arr=$font_family.split(":");
						if($font_arr.length>0 && isNumber($font_arr[1]))
						{
							$font_weight=$font_arr[1];
							$font_name=$font_arr[0].replace("+"," ");
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css({"font-family":$font_name,"font-weight":$font_weight});
						}else
						{
							jQuery(".pw-check-font-'.$settings['param_name'].'-family").css("font-family",jQuery(this).find(":selected").text());
						}
					});
					
				});
			
			</script>
			<p class="pw-check-font-'.$settings['param_name'].'-family">Grumpy wizards make toxic brew for the evil Queen and Jack.</p>
			
				
			<script type="text/javascript">
			
				var value_font=[];
				jQuery(document).ready(function(){
					
					jQuery(".'.$settings['param_name'].'-colorpicker-adv_font").wpColorPicker({
						change:function(event, ui) {
							
							value_font=[];
							jQuery("#'.$settings['param_name'].'-adv_font").val("");
							
							jQuery(".'.$settings['param_name'].'-adv_font").each(function(){
								
								
								var font_field=jQuery(this).val();
								if(font_field!=""){
									value_font.push(font_field);			
								}else{
									font_field=0;
									value_font.push(font_field);				
								}
							});	
							
							if(jQuery(this).hasClass("main_color"))
								value_font.splice(2, 0, ui.color.toString());	
								
							if(jQuery(this).hasClass("hover_color"))
								value_font.splice(3, 0, ui.color.toString());	
							
							//value_font.push(ui.color.toString());
							var cur_val=value_font.join(",");
							jQuery("#'.$settings['param_name'].'-adv_font").val(cur_val);
						}
					});
					
					jQuery(".'.$settings['param_name'].'-adv_font").live("change",function(){
						value_font=[];
						jQuery("#'.$settings['param_name'].'-adv_font").val("");
						
						jQuery(".'.$settings['param_name'].'-adv_font").each(function(){
							var font_field=jQuery(this).val();
							if(font_field!=""){
								value_font.push(font_field);			
							}else{
								font_field=0;
								value_font.push(font_field);				
							}
						});	
						var cur_val=value_font.join(",");
						jQuery("#'.$settings['param_name'].'-adv_font").val(cur_val);
					});
					
				});
				
			</script>';
			 
			 
			 
		return $param_line;	 
	}
	
	
	//Border Setting Patam
	function pw_border_settings_field($settings, $value){
			$dependency='';
			
			$meta=array(0,0,0,0,'dashed',"#dddddd");
			if($value!='')
			{
				$meta=explode(",",$value);
			}else{
				$value='';
			}
			
			$param_line = '<input name="'.$settings['param_name']
				 .'" class="wpb_vc_param_value wpb-textinput '
				 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" id="'.$settings['param_name'].'-border-option" type="hidden" value="'.$value.'" ' . $dependency . '/>
				 <div class="pl-field-cnt pl-half-four-field">
					 <label>Top</label>
					 <input name="'.$settings['param_name']
					 .'" class="'.$settings['param_name'].'-border-element wpb_vc_param_value wpb-textinput '
					 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="number" value="'.$meta[0].'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;" />
				 </div>			 
				 <div class="pl-field-cnt pl-half-four-field">
					 <label>Right</label>
					 <input name="'.$settings['param_name']
					 .'" class="'.$settings['param_name'].'-border-element wpb_vc_param_value wpb-textinput '
					 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="number" value="'.$meta[1].'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;" />
				 </div>
				 <div class="pl-field-cnt pl-half-four-field">
					 <label>Bottom</label>
					 <input name="'.$settings['param_name']
					 .'" class="'.$settings['param_name'].'-border-element wpb_vc_param_value wpb-textinput '
					 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="number" value="'.$meta[2].'" ' . $dependency . '  style="max-width:50px; margin-right: 10px;" />
				 </div>
				 <div class="pl-field-cnt pl-half-four-field">
					 <label>Left</label>
					 <input name="'.$settings['param_name']
					 .'" class="'.$settings['param_name'].'-border-element wpb_vc_param_value wpb-textinput '
					 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="number" value="'.$meta[3].'" ' . $dependency . ' style="max-width:50px; margin-right: 10px;"  />
				 </div>
				 <div class="pl-field-cnt">
					 <label>Type</label>
					 <select name="'.$settings['param_name'].'" class="'.$settings['param_name'].'-border-element wpb_vc_param_value wpb-select '
					 .$settings['param_name'].' '.$settings['type'].'_field" id="'.$settings['param_name'].'-type" >
					 <option value="dashed" "'.selected("dashed",$meta[4],0).'">Dashed</option>
					 <option value="solid" "'.selected("solid",$meta[4],0).'">Solid</option>
					 <option value="dotted" "'.selected("dotted",$meta[4],0).'">Dotted</option>
					 <option value="double" "'.selected("double",$meta[4],0).'">Double</option>
					 <option value="thin" "'.selected("thin",$meta[4],0).'">Thin</option>
					</select>
				 </div>
				 <div class="pl-field-cnt">
					 <label>Color</label>
					 <input name="'.$settings['param_name']
					 .'" class="'.$settings['param_name'].'-colorpicker-border '.$settings['param_name'].'-border-element wpb_vc_param_value wpb-textinput '
					 .$settings['param_name'].' '.$settings['type'].' '.$settings['class'].'" type="text" value="'.$meta[5].'" ' . $dependency . '  data-default-color="#7C7C7C"/>
				 </div>
				 
				 
				<script type="text/javascript">
				
					var value_font=[];
					jQuery(document).ready(function(){
						
						jQuery(".'.$settings['param_name'].'-colorpicker-border").wpColorPicker({
							change:function(event, ui) {
								
								value_border=[];
								jQuery("#'.$settings['param_name'].'-border-option").val("");
								
								jQuery(".'.$settings['param_name'].'-border-element").each(function(){
									if(jQuery(this).hasClass("'.$settings['param_name'].'-colorpicker-border"))
										return;
										
									var border_field=jQuery(this).val();
									if(border_field!=""){
										value_border.push(border_field);			
									}else{
										border_field=0;
										value_border.push(border_field);				
									}
								});
								value_border.push(ui.color.toString());
								var cur_val=value_border.join(",");
								jQuery("#'.$settings['param_name'].'-border-option").val(cur_val);
							}
						});
						
						jQuery(".'.$settings['param_name'].'-border-element").change(function(){
							value_border=[];
							jQuery("#'.$settings['param_name'].'-border-option").val("");
							
							jQuery(".'.$settings['param_name'].'-border-element").each(function(){
								var border_field=jQuery(this).val();
								if(border_field!=""){
									value_border.push(border_field);			
								}else{
									border_field=0;
									value_border.push(border_field);				
								}
							});	
							var cur_val=value_border.join(",");
							jQuery("#'.$settings['param_name'].'-border-option").val(cur_val);
						});
						
					});
					
				</script>';
				 
				 
				 
			return $param_line;	 
		}
		
		
	public function includes()	{

		require_once( 'class/pro_news_ticker.php');
	}
	
	function pw_pro_news_ticker_shortcodes_add_scripts() {
		if(!is_admin()) {
			/*Public Styles*/
			wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_fontawesome', plugin_dir_url_pw_pro_news_ticker.'/css/fontawesome/font-awesome.css');
			wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_public', plugin_dir_url_pw_pro_news_ticker.'/css/public.css');
			
			wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_bxslider', plugin_dir_url_pw_pro_news_ticker.'/css/bx-slider/jquery.bxslider.css');
			
			wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_magnific_popup', plugin_dir_url_pw_pro_news_ticker.'/css/magnific-popup/magnific-popup.css');
			
			wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_marquee', plugin_dir_url_pw_pro_news_ticker.'/css/marquee/imarquee.css');
			
			wp_register_style( __PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_news_ticker_rtl', plugin_dir_url_pw_pro_news_ticker.'/css/rtl/rtl.css', false, '1.0.0' );
			
			
			
			wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_vs_custom_css', plugin_dir_url_pw_pro_news_ticker.'/css/custom-css.css');
			
			/*SCRIPTS*/
			wp_enqueue_script('jquery');
			
			/* Scripts */
			wp_register_script(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_bxslider', plugin_dir_url_pw_pro_news_ticker.'js/bx-slider/jquery.bxslider.js', 'jquery');
			wp_enqueue_script(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_bxslider');
			
			
			wp_register_script(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_magnific_popup', plugin_dir_url_pw_pro_news_ticker.'js/magnific-popup/jquery.magnific-popup.js', 'jquery');
			wp_enqueue_script(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_magnific_popup');
			
			wp_register_script(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_marquee', plugin_dir_url_pw_pro_news_ticker.'js/marquee/imarquee.js', 'jquery');
			wp_enqueue_script(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_marquee');
			
			
		}else
		{
			
			
			
			
		}
	}


}
new pw_pro_news_ticker_plugin();
?>